//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#property description "DEMO Indicator"
//+------------------------------------------------------------------+
const struct stAverange
{
    int            nPeriods;
    ENUM_MA_METHOD Method;
    color          cor;
}Averange[] = 
{
    {20, MODE_SMA, clrBlack}
};
//+----------------+
#property indicator_chart_window
#property indicator_applied_price   PRICE_CLOSE
#property indicator_buffers         Averange.Size();
#property indicator_plots           Averange.Size();
//+------------------------------------------------------------------+
struct stInfos
{
    double  Buff[];
}Infos[Averange.Size()];
//+------------------------------------------------------------------+
int OnInit(void)
{
    for (uint c = 0; c < Averange.Size(); c++)
    {
        SetIndexBuffer(c, Infos[c].Buff, INDICATOR_DATA);
        PlotIndexSetInteger(c, PLOT_DRAW_TYPE, DRAW_LINE);
        PlotIndexSetInteger(c, PLOT_LINE_STYLE, STYLE_SOLID);
        PlotIndexSetInteger(c, PLOT_LINE_WIDTH, 2);
        PlotIndexSetInteger(c, PLOT_LINE_COLOR, Averange[c].cor);
        PlotIndexSetString(c, PLOT_LABEL, StringFormat("Arithmetic of %d", Averange[c].nPeriods));
    }

       return INIT_SUCCEEDED;
};
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total, const int prev_calculated, const int begin, const double &price[])
{

    for (uint c = 0; c < Averange.Size(); c++)
    {
        if (prev_calculated == 0)
        {
            double loc = 0;
            for (int c1 = 0; c1 < Averange[c].nPeriods; c1++) loc += price[Averange[c].nPeriods - c1];
                Infos[c].Buff[Averange[c].nPeriods] = loc / Averange[c].nPeriods;
        }
        switch (Averange[c].Method)
        {
            case MODE_SMA:
                for (int i = (prev_calculated > 0 ? prev_calculated - 1 : Averange[c].nPeriods + 1); i < rates_total; i++)
                    Infos[c].Buff[i] = ((Infos[c].Buff[i - 1] * Averange[c].nPeriods) - price[i - Averange[c].nPeriods] + price[i]) / Averange[c].nPeriods;
                break;
        }
    }

    return rates_total;
};
//+------------------------------------------------------------------+